
#include <windows.h>
#include <stdlib.h>
#include <mmsystem.h>
#include "detmmx.h"
#include "dxdraw.h"
#include "inifile.h"
#include "main.h"

VOID DllInitLoadINIFile(VOID);
VOID LoadINIFile(VOID);

char gszGlide2xName[MAX_PATH + 1] = "glide2x.dll";
CONST char DEFAULT_GLIDE2X_NAME[] = "glide2x.dll";
BOOL gbUseMMX = FALSE;
BOOL gbMultiThreading = FALSE;
BOOL gbSystemMenuOptions = FALSE;
BOOL gbDisableResizeSubclass = FALSE;
BOOL gb320x240Fix = FALSE;

DWORD gdwWinGlideMode = WINGLIDE_MODE_B2;

BOOL gbEnableGammaCorrection = FALSE;
float gRedGamma = 1.7f, gGreenGamma = 1.7f, gBlueGamma = 1.7f;

BOOL gbUseDoubleBufferedOverlay = FALSE;
DWORD gdwBackBufferCount = 0;
DWORD gdwOverlayFlags = 0;
BOOL gbAutoDetectOverlayClipping = TRUE;
COLORREF gcrColorKey = RGB(112, 112, 112);
BOOL gbUseFourCCSurface = FALSE;
FOURCC gFourCC;

static const char szINIFileName[] = "wg.ini";

static const char szWinGlideSection[] = "WinGlide";
static const char szGlide2xName[] = "Glide2x";
static const char szEnableMMX[] = "MMX";
static const char szMultiThreading[] = "Multi-threading";
static const char szSystemMenuOptions[] = "SystemMenuOptions";
static const char szDisableResizeSubclass[] = "DisableResizeSubclass";
static const char sz320x240Fix[] = "320x240Fix";

static const char szModeSection[] = "Mode";
static const char szB2WinGlide[] = "B2WinGlide";
static const char szStretchBltWinGlide[] = "StretchBltWinGlide";
static const char szOverlayWinGlide[] = "OverlayWinGlide";
static const char szOffScreenSurfaceWinGlide[] = "OffScreenSurfaceWinGlide";

static const char szGammaCorrectionSection[] = "GammaCorrection";
static const char szEnableGammaCorrection[] = "Enable";
static const char szRedGamma[] = "Red";
static const char szGreenGamma[] = "Green";
static const char szBlueGamma[] = "Blue";

static const char szOverlaySection[] = "Overlay";
static const char szBackBufferCount[] = "BackBufferCount";
static const char szEnableColorKeyClipping[] = "ColorKeyClipping";
static const char szEnableWindowClipping[] = "WindowClipping";
static const char szEnableAlphaBlending[] = "AlphaBlending";
static const char szRedColorKey[] = "Red";
static const char szGreenColorKey[] = "Green";
static const char szBlueColorKey[] = "Blue";
static const char szUseFourCCSurface[] = "UseFourCCSurface";
static const char szFourCharacterCode[] = "FourCC";


VOID DllInitLoadINIFile(VOID) {
	char szINIFilePath[MAX_PATH + 1];
	DWORD dwRet;
	int i;
	UINT uiRet;

	//Load DLL initialization ini file settings from the directory that WinGlide is in
	//Build the string containing the directory of the ini file
	dwRet = GetModuleFileName(ghDllInst, szINIFilePath, sizeof(szINIFilePath));
	if (dwRet == 0) {
		//Could not get the name of the module
//TODO: report this error
		return;
	}

	//Find the last path seperator in the string and put a NULL after it
	i = lstrlen(szINIFilePath);
	while (i-- > 0) {
		if (szINIFilePath[i] == '\\') {
			szINIFilePath[i + 1] = 0;
			break;
		}
	}
	
	//Add the name of the ini file to the directory of the ini file if there is space
	if ((lstrlen(szINIFileName) + lstrlen(szINIFilePath)) >= sizeof(szINIFilePath)) {
		//Error, not enough room in szINIFilePath
//TODO: report this error
		return;
	}
	
	//Add the name of the ini file to the directory of the ini file
	lstrcat(szINIFilePath, szINIFileName);

	//See if the alternate glide2x.dll name is being used
	GetPrivateProfileString(szWinGlideSection, szGlide2xName, DEFAULT_GLIDE2X_NAME,
		gszGlide2xName, sizeof(gszGlide2xName), szINIFilePath);

	
	//Set defaults
	gb320x240Fix = FALSE;

	//Load the ini file
	//WinGlide section
	uiRet = GetPrivateProfileInt(szWinGlideSection, sz320x240Fix,
		0, szINIFilePath);
	if (uiRet == 1) {
		gb320x240Fix = TRUE;
	}

	
	return;
}

VOID LoadINIFile(VOID) {
	char szINIFilePath[MAX_PATH + 1];
	DWORD dwRet;
	int i;
	UINT uiRet;
	BYTE bRedColorKey, bGreenColorKey, bBlueColorKey;
	char szNumberBuffer[10 + 1];
	HANDLE hINIFile;
	BOOL bExists;

	//Use the directory of the application being used with WinGlide
	//Build the string containing the directory of the ini file
	dwRet = GetModuleFileName(NULL, szINIFilePath, sizeof(szINIFilePath));
	if (dwRet == 0) {
		//Could not get the name of the module
//TODO: report this error
		return;
	}

	//Find the last path seperator in the string and put a NULL after it
	i = lstrlen(szINIFilePath);
	while (i-- > 0) {
		if (szINIFilePath[i] == '\\') {
			szINIFilePath[i + 1] = 0;
			break;
		}
	}
	
	//Add the name of the ini file to the directory of the ini file if there is space
	if ((lstrlen(szINIFileName) + lstrlen(szINIFilePath)) >= sizeof(szINIFilePath)) {
		//Error, not enough room in szINIFilePath
//TODO: report this error
		return;
	}
	
	//Add the name of the ini file to the directory of the ini file
	lstrcat(szINIFilePath, szINIFileName);

	//See if the ini file exists in the directory of the application being used with WinGlide
	hINIFile = CreateFile(szINIFilePath, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (hINIFile != INVALID_HANDLE_VALUE) {
		//The exists
		CloseHandle(hINIFile);
		bExists = TRUE;
	}
	else {
		bExists = FALSE;
	}

	//If it does not exist, use the directory that WinGlide is in
	if (bExists == FALSE) {
		//Use the directory that WinGlide is in
		//Build the string containing the directory of the ini file
		dwRet = GetModuleFileName(ghDllInst, szINIFilePath, sizeof(szINIFilePath));
		if (dwRet == 0) {
			//Could not get the name of the module
	//TODO: report this error
			return;
		}

		//Find the last path seperator in the string and put a NULL after it
		i = lstrlen(szINIFilePath);
		while (i-- > 0) {
			if (szINIFilePath[i] == '\\') {
				szINIFilePath[i + 1] = 0;
				break;
			}
		}
		
		//Add the name of the ini file to the directory of the ini file if there is space
		if ((lstrlen(szINIFileName) + lstrlen(szINIFilePath)) >= sizeof(szINIFilePath)) {
			//Error, not enough room in szINIFilePath
	//TODO: report this error
			return;
		}
		
		//Add the name of the ini file to the directory of the ini file
		lstrcat(szINIFilePath, szINIFileName);
	}


	//Set defaults
	gbUseMMX = FALSE;
	gbMultiThreading = FALSE;
	gbSystemMenuOptions = FALSE;
	gbDisableResizeSubclass = FALSE;

	gdwWinGlideMode = WINGLIDE_MODE_B2;

	gbEnableGammaCorrection = FALSE;
	gRedGamma = 1.7f;
	gGreenGamma = 1.7f;
	gBlueGamma = 1.7f;

	gbUseDoubleBufferedOverlay = FALSE;
	gdwBackBufferCount = 1;
	gdwOverlayFlags = 0;
	gbAutoDetectOverlayClipping = TRUE;
	gcrColorKey = RGB(112, 112, 112);
	gbUseFourCCSurface = FALSE;

	//Load the ini file
	//WinGlide section
	uiRet = GetPrivateProfileInt(szWinGlideSection, szEnableMMX,
		2, szINIFilePath);
	if (uiRet == 1) {
		gbUseMMX = TRUE;
	}
	else if (uiRet == 0) {
		gbUseMMX = FALSE;
	}
	else {
		//Detect MMX support
		if (DetectMMX() != 0) {
			gbUseMMX = TRUE;
		}
		else {
			gbUseMMX = FALSE;
		}
	}

	uiRet = GetPrivateProfileInt(szWinGlideSection, szMultiThreading,
		2, szINIFilePath);
	if (uiRet == 1) {
		gbMultiThreading = TRUE;
	}
	else if (uiRet == 0) {
		gbMultiThreading = FALSE;
	}
	else {
		//Detect the number of processors
		SYSTEM_INFO systemInfo;

		//Fill the systemInfo structure
		GetSystemInfo(&systemInfo);

		//Use multi-threading if more than one processor is present
		if (systemInfo.dwNumberOfProcessors > 1) {
			gbMultiThreading = TRUE;
		}
		else {
			gbMultiThreading = FALSE;
		}
	}

	uiRet = GetPrivateProfileInt(szWinGlideSection, szSystemMenuOptions,
		0, szINIFilePath);
	if (uiRet == 1) {
		gbSystemMenuOptions = TRUE;
	}

	uiRet = GetPrivateProfileInt(szWinGlideSection, szDisableResizeSubclass,
		0, szINIFilePath);
	if (uiRet == 1) {
		gbDisableResizeSubclass = TRUE;
	}

	//Mode section
	uiRet = GetPrivateProfileInt(szModeSection, szB2WinGlide,
		0, szINIFilePath);
	if (uiRet == 1) {
		gdwWinGlideMode = WINGLIDE_MODE_B2;
		goto done_choosing_mode;
	}

	uiRet = GetPrivateProfileInt(szModeSection, szStretchBltWinGlide,
		0, szINIFilePath);
	if (uiRet == 1) {
		gdwWinGlideMode = WINGLIDE_MODE_STRETCH_BLT;
		goto done_choosing_mode;
	}

	uiRet = GetPrivateProfileInt(szModeSection, szOverlayWinGlide,
		0, szINIFilePath);
	if (uiRet == 1) {
		gdwWinGlideMode = WINGLIDE_MODE_OVERLAY;
		goto done_choosing_mode;
	}
	
	uiRet = GetPrivateProfileInt(szModeSection, szOffScreenSurfaceWinGlide,
		0, szINIFilePath);
	if (uiRet == 1) {
		gdwWinGlideMode = WINGLIDE_MODE_OFF_SCREEN_SURFACE;
		goto done_choosing_mode;
	}
	
	//Set default mode if no modes were selected
	gdwWinGlideMode = WINGLIDE_MODE_B2;

	//End of the mode section
done_choosing_mode:

	//Gamma correction section
	uiRet = GetPrivateProfileInt(szGammaCorrectionSection, szEnableGammaCorrection,
		0, szINIFilePath);
	if (uiRet == 1) {
		gbEnableGammaCorrection = TRUE;
	}

	GetPrivateProfileString(szGammaCorrectionSection, szRedGamma,
		"1.7", szNumberBuffer, sizeof(szNumberBuffer), szINIFilePath);
	gRedGamma = (float)atof(szNumberBuffer);
	if (gRedGamma < 0.0f) { gRedGamma = 0.0f; }
	if (gRedGamma > 5.0f) { gRedGamma = 5.0f; }

	GetPrivateProfileString(szGammaCorrectionSection, szGreenGamma,
		"1.7", szNumberBuffer, sizeof(szNumberBuffer), szINIFilePath);
	gGreenGamma = (float)atof(szNumberBuffer);
	if (gGreenGamma < 0.0f) { gGreenGamma = 0.0f; }
	if (gGreenGamma > 5.0f) { gGreenGamma = 5.0f; }

	GetPrivateProfileString(szGammaCorrectionSection, szBlueGamma,
		"1.7", szNumberBuffer, sizeof(szNumberBuffer), szINIFilePath);
	gBlueGamma = (float)atof(szNumberBuffer);
	if (gBlueGamma < 0.0f) { gBlueGamma = 0.0f; }
	if (gBlueGamma > 5.0f) { gBlueGamma = 5.0f; }

	//Overlay section
	uiRet = GetPrivateProfileInt(szOverlaySection, szBackBufferCount,
		0, szINIFilePath);
	if (uiRet == 1) {
		gbUseDoubleBufferedOverlay = TRUE;
		gdwBackBufferCount = 1;
	}
	else if (uiRet == 2) {
		gbUseDoubleBufferedOverlay = TRUE;
		gdwBackBufferCount = 2;
	}
	
	uiRet = GetPrivateProfileInt(szOverlaySection, szEnableColorKeyClipping,
		2, szINIFilePath);
	if (uiRet == 1) {
		gdwOverlayFlags |= OVERLAY_ENABLE_COLOR_KEY_CLIPPING;
	}
	if (uiRet != 2) {
		gbAutoDetectOverlayClipping = FALSE;
	}
	
	uiRet = GetPrivateProfileInt(szOverlaySection, szEnableWindowClipping,
		2, szINIFilePath);
	if (uiRet == 1) {
		gdwOverlayFlags |= OVERLAY_ENABLE_WINDOW_CLIPPING;
	}
	if (uiRet != 2) {
		gbAutoDetectOverlayClipping = FALSE;
	}

	uiRet = GetPrivateProfileInt(szOverlaySection, szEnableAlphaBlending,
		0, szINIFilePath);
	if (uiRet == 1) {
		gdwOverlayFlags |= OVERLAY_ENABLE_ALPHA_BLENDING;
	}

	bRedColorKey = GetPrivateProfileInt(szOverlaySection, szRedColorKey,
		112, szINIFilePath);
	bGreenColorKey = GetPrivateProfileInt(szOverlaySection, szGreenColorKey,
		112, szINIFilePath);
	bBlueColorKey = GetPrivateProfileInt(szOverlaySection, szBlueColorKey,
		112, szINIFilePath);
	gcrColorKey = RGB(bRedColorKey, bGreenColorKey, bBlueColorKey);

	uiRet = GetPrivateProfileInt(szOverlaySection, szUseFourCCSurface,
		0, szINIFilePath);
	if (uiRet == 1) {
		gbUseFourCCSurface = TRUE;
	}

	if (gbUseFourCCSurface == TRUE) {
		char szFourCC[4 + 1] = "0000";

		GetPrivateProfileString(szOverlaySection, szFourCharacterCode,
			"YUY2", szFourCC, sizeof(szFourCC), szINIFilePath);

		gFourCC = mmioFOURCC(szFourCC[0], szFourCC[1], szFourCC[2], szFourCC[3]);
	}

	return;
}
